<?php

/**
 * My Account page
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/my-account.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.5.0
 */

defined( 'ABSPATH' ) || exit;?>
<div class="theme-container">
	<?php do_action( 'kls_breadcrumb' ); ?>
	<div class="theme-row">
		<?php
		if ( get_theme_mod( 'kls_my_account_menu_toggle', '1' ) == '1' ) :
			?>
			<div class="theme-col theme-col-3">
				<?php
				/**
				 * My Account navigation.
				 *
				 * @since 2.6.0
				 */
				do_action( 'woocommerce_account_navigation' );
				?>
			</div>
			<div class="theme-col theme-col-9">
			<?php
		else :
			?>
			<div class="theme-col theme-col-12">
			<?php
		endif;
		?>
			<div class="woocommerce-account-content">
				<?php
					/**
					 * My Account content.
					 *
					 * @since 2.6.0
					 */
					do_action( 'woocommerce_account_content' );
				?>
			</div>
		</div>
	</div>
</div>
