<?php

/**
 * View Order
 *
 * Shows the details of a particular order on the account page.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/view-order.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.0.0
 */

defined( 'ABSPATH' ) || exit;
$notes = $order->get_customer_order_notes();
?>
<h3 class="account-page-title"><i class="fas fa-box-open"></i><?php echo __( 'Order', 'klasse-theme' ) . ' #' . $order->get_order_number(); ?></h3>

<div class="woocommerce-order-overview woocommerce-thankyou-order-details order_details">
	<div class="woocommerce-order-overview__order order order-item">
		<?php esc_html_e( 'Order number:', 'klasse-theme' ); ?>
		<strong><?php echo $order->get_order_number(); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></strong>
	</div>

	<div class="woocommerce-order-overview__status status order-item">
		<?php esc_html_e( 'Status', 'klasse-theme' ); ?>
		<strong><?php echo wc_get_order_status_name( $order->get_status() ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></strong>
	</div>

	<div class="woocommerce-order-overview__date date order-item">
		<?php esc_html_e( 'Date:', 'klasse-theme' ); ?>
		<strong><?php echo wc_format_datetime( $order->get_date_created() ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></strong>
	</div>

	<div class="woocommerce-order-overview__total total order-item">
		<?php esc_html_e( 'Total:', 'klasse-theme' ); ?>
		<strong><?php echo $order->get_formatted_order_total(); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></strong>
	</div>
</div>

<?php
if ( $notes ) :
	?>
	<h2><?php esc_html_e( 'Order updates', 'klasse-theme' ); ?></h2>
 <ol class="woocommerce-OrderUpdates commentlist notes">
		<?php
		foreach ( $notes as $note ) :
			?>
	   <li class="woocommerce-OrderUpdate comment note">
		  <div class="woocommerce-OrderUpdate-inner comment_container">
			  <div class="woocommerce-OrderUpdate-text comment-text">
					<p class="woocommerce-OrderUpdate-meta meta"><?php echo date_i18n( esc_html__( 'l jS \o\f F Y, h:ia', 'klasse-theme' ), strtotime( $note->comment_date ) ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></p>
				  <div class="woocommerce-OrderUpdate-description description">
						<?php echo wpautop( wptexturize( $note->comment_content ) ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
				 </div>
				 <div class="clear"></div>
			  </div>
			 <div class="clear"></div>
		  </div>
	 </li>
			<?php
		endforeach;
		?>
 </ol>
	<?php
endif;
?>

<?php do_action( 'woocommerce_view_order', $order_id ); ?>
