<?php

/**
 * Show error messages
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.9.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! $notices ) {
	return;
}

?>
<div class="theme-container">
	<div class="theme-row">
		<div class="theme-col theme-col-12">
			<ul class="woocommerce-error" role="alert">
				<?php
				foreach ( $notices as $notice ) :
					?>
				<li<?php echo wc_get_notice_data_attr( $notice ); ?>>
					<?php echo wc_kses_notice( $notice['notice'] ); ?>
					</li>
					<?php
				endforeach;
				?>
			</ul>
		</div>
	</div>
</div>
