<?php

/**
 * Single Product Meta
 *
 * @see         https://docs.woocommerce.com/document/template-structure/
 * @package     WooCommerce\Templates
 * @version     3.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $product;
?>
<div class="product_meta">

	<?php do_action( 'woocommerce_product_meta_start' ); ?>

	<?php
	if ( wc_product_sku_enabled() && ( $product->get_sku() || $product->is_type( 'variable' ) ) ) :
		?>

		<span class="sku_wrapper"><?php esc_html_e( 'SKU:', 'klasse-theme' ); ?> <span class="sku"><?php echo ( $sku = $product->get_sku() ) ? $sku : esc_html__( 'N/A', 'klasse-theme' ); ?></span></span>

		<?php
	endif;
	?>

	<?php

	echo wc_get_product_category_list( $product->get_id(), ', ', '<span class="posted_in">' . _n( 'Category:', 'Categories:', count( $product->get_category_ids() ), 'klasse-theme' ) . ' ', '</span>' );

	?>

	<?php

	echo wc_get_product_tag_list( $product->get_id(), ', ', '<span class="tagged_as">' . _n( 'Tag:', 'Tags:', count( $product->get_tag_ids() ), 'klasse-theme' ) . ' ', '</span>' );

	?>

	<?php do_action( 'woocommerce_product_meta_end' ); ?>

</div>
