<?php

/**
 * Related Products
 *
 * @see         https://docs.woocommerce.com/document/template-structure/
 * @package     WooCommerce\Templates
 * @version     3.9.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( $related_products && get_theme_mod( 'product_related_products_toggle' ) == 1 ) :
	?>

   <section class="related products">

		<?php echo get_template_part( '/template-parts/woocommerce/single-product/related_title', $GLOBALS['kls_product_style_version'] ); ?>
	  
		<?php woocommerce_product_loop_start(); ?>

			<?php
			foreach ( $related_products as $related_product ) :
				?>

					<?php
					$post_object = get_post( $related_product->get_id() );
					setup_postdata( $GLOBALS['post'] =& $post_object ); // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited, Squiz.PHP.DisallowMultipleAssignments.Found

					wc_get_template_part( 'content', 'product' );
					?>

				<?php
			endforeach;
			?>

		<?php woocommerce_product_loop_end(); ?>

   </section>
	<?php
endif;
wp_reset_postdata();
