<?php

/**
 * Single Product Sale Flash
 *
 * @see         https://docs.woocommerce.com/document/template-structure/
 * @package     WooCommerce\Templates
 * @version     1.6.4
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
	// Exit if accessed directly
}

global $post, $product;
$featured = $product->is_featured();
$sale     = $product->is_on_sale();
if ( $featured || $sale ) :
	echo '<div class="product-labels product-labels-single-product">';
	if ( get_theme_mod( 'general_hot_label_toggle' ) == 1 && $featured ) {
		echo '<div class="onhot">' . ( get_theme_mod( 'general_hot_label_text' ) ? kls_translate_theme_mod( 'general_hot_label_text', 'HOT tekst', 'nl' ) : __( 'Hot', 'klasse-theme' ) ) . '</div>';
	}

	if ( get_theme_mod( 'general_sales_label_toggle' ) == 1 && $sale ) {
		$percentage = 0;
		$reg_p      = floatval( $product->get_regular_price() );
		if ( $reg_p ) {
			$percentage = - round( ( ( $reg_p - $product->get_sale_price() ) / $reg_p ) * 100 );
		} elseif ( 'variable' == $product->get_type() && $product->get_variation_regular_price() ) {
			$percentage = - round( ( ( $product->get_variation_regular_price() - $product->get_variation_sale_price() ) / $product->get_variation_regular_price() ) * 100 );
		}
		if ( get_theme_mod( 'general_sales_label_percentage_toggle' ) == 1 && $percentage ) {
			$sales_html = '<div class="onsale">' . $percentage . '%</div>';
		} else {
			$sales_html = apply_filters( 'woocommerce_sale_flash', '<div class="onsale">' . __( 'Sale', 'klasse-theme' ) . '</div>', $post, $product );
		}
		echo $sales_html;
	}

	echo '</div>';
endif;
