<?php

/**
 * Single Product Up-Sells
 *
 * @see         https://docs.woocommerce.com/document/template-structure/
 * @package     WooCommerce\Templates
 * @version     3.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( $upsells && get_theme_mod( 'product_up_sells_toggle' ) == 1 ) :
	?>

 <section class="up-sells upsells products">
		<?php echo get_template_part( '/template-parts/woocommerce/single-product/upsells_title', $GLOBALS['kls_product_style_version'] ); ?>

		<?php woocommerce_product_loop_start(); ?>

			<?php
			foreach ( $upsells as $upsell ) :
				?>

				<?php
				$post_object = get_post( $upsell->get_id() );
				setup_postdata( $GLOBALS['post'] =& $post_object ); // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited, Squiz.PHP.DisallowMultipleAssignments.Found

				wc_get_template_part( 'content', 'product' );
				?>

				<?php
			endforeach;
			?>

		<?php woocommerce_product_loop_end(); ?>

	</section>

	<?php
endif;
wp_reset_postdata();
