<?php
/**
 * Wishlist pages template; load template parts basing on the url
 *
 * @author YITH
 * @package YITH\Wishlist\Templates\Wishlist
 * @version 3.0.0
 */

/**
 * Template Variables:
 *
 * @var $template_part string Sub-template to load
 * @var $var array Array of attributes that needs to be sent to sub-template
 */

if ( ! defined( 'YITH_WCWL' ) ) {
	exit;
} // Exit if accessed directly
?>
<div class="theme-container">
	<?php do_action( 'kls_breadcrumb' ); ?>
</div>

<div class="theme-container">
	<div class="theme-row">
		<div class="theme-col theme-col-12">
			<?php do_action( 'yith_wcwl_before_wishlist_form', $wishlist ); ?>

			<form
				id="yith-wcwl-form"
				action="<?php echo esc_attr( $form_action ); ?>"
				method="post"
				class="woocommerce yith-wcwl-form wishlist-fragment"
				data-fragment-options="<?php echo wc_esc_json( wp_json_encode( $fragment_options ) ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>"
			>

			<!-- TITLE -->
			<?php
			do_action( 'yith_wcwl_before_wishlist_title', $wishlist );

			if ( ! empty( $page_title ) ) :
				?>
				<div class="wishlist-title-container">
					<div class="wishlist-title <?php echo ( $can_user_edit_title ) ? 'wishlist-title-with-form' : ''; ?>">
						<?php echo wp_kses_post( apply_filters( 'yith_wcwl_wishlist_title', '<h2>' . $page_title . '</h2>' ) ); ?>
						<?php
						if ( $can_user_edit_title ) :
							?>
							<a class="btn button show-title-form">
								<?php echo yith_wcwl_kses_icon( apply_filters( 'yith_wcwl_edit_title_icon', '<i class="fa fa-pencil"></i>' ) ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
								<?php esc_html_e( 'Edit title', 'klasse-theme' ); ?>
							</a>
							<?php
						endif;
						?>
					</div>
					<?php
					if ( $can_user_edit_title ) :
						?>
						<div class="hidden-title-form">
							<input type="text" value="<?php echo esc_attr( $page_title ); ?>" name="wishlist_name"/>
							<div class="edit-title-buttons">
								<a role="button" href="#" class="hide-title-form">
									<?php echo yith_wcwl_kses_icon( apply_filters( 'yith_wcwl_cancel_wishlist_title_icon', '<i class="fas fa-times"></i>' ) ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
								</a>
								<a role="button" href="#" class="save-title-form">
									<?php echo yith_wcwl_kses_icon( apply_filters( 'yith_wcwl_save_wishlist_title_icon', '<i class="fa fa-check"></i>' ) ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
								</a>
							</div>
						</div>
						<?php
					endif;
					?>
				</div>
				<?php
			endif;
			do_action( 'yith_wcwl_before_wishlist', $wishlist );
			?>

			<!-- WISHLIST TABLE -->
			<?php
			if ( $wishlist && $wishlist->has_items() ) :
				?>
			<table
				class="shop_table shop_table_responsive cart wishlist_table wishlist_view traditional responsive <?php echo $no_interactions ? 'no-interactions' : ''; ?> <?php echo $enable_drag_n_drop ? 'sortable' : ''; ?> "
				data-pagination="<?php echo esc_attr( $pagination ); ?>" data-per-page="<?php echo esc_attr( $per_page ); ?>" data-page="<?php echo esc_attr( $current_page ); ?>"
				data-id="<?php echo esc_attr( $wishlist_id ); ?>" data-token="<?php echo esc_attr( $wishlist_token ); ?>">

				<?php $column_count = 2; ?>
					<thead>
						<tr>
							<?php
							if ( $show_cb ) :
								?>
								<?php $column_count++; ?>
								<th class="product-checkbox">
									<input type="checkbox" value="" name="" id="bulk_add_to_cart"/>
								</th>
								<?php
							endif;
							?>

							<th class="product-thumbnail"></th>

							<th class="product-name">
								<span class="nobr">
									<?php echo esc_html( apply_filters( 'yith_wcwl_wishlist_view_name_heading', __( 'Product name', 'klasse-theme' ), $wishlist ) ); ?>
								</span>
							</th>

							<?php
							if ( $show_price || $show_price_variations ) :
								?>
								<?php $column_count++; ?>
								<th class="product-price">
									<span class="nobr">
										<?php echo esc_html( apply_filters( 'yith_wcwl_wishlist_view_price_heading', __( 'Unit price', 'klasse-theme' ), $wishlist ) ); ?>
									</span>
								</th>
								<?php
							endif;
							?>

							<?php
							if ( $show_quantity ) :
								?>
								<?php $column_count++; ?>
								<th class="product-quantity">
									<span class="nobr">
										<?php echo esc_html( apply_filters( 'yith_wcwl_wishlist_view_quantity_heading', __( 'Quantity', 'klasse-theme' ), $wishlist ) ); ?>
									</span>
								</th>
								<?php
							endif;
							?>

							<?php
							if ( $show_stock_status && get_theme_mod( 'wishlist_stock_status_toggle' ) == 1 ) :
								?>
								<?php $column_count++; ?>
								<th class="product-stock-status">
									<span class="nobr">
										<?php echo esc_html( apply_filters( 'yith_wcwl_wishlist_view_stock_heading', __( 'Stock status', 'klasse-theme' ), $wishlist ) ); ?>
									</span>
								</th>
								<?php
							endif;
							?>

							<?php
							if ( $show_last_column ) :
								?>
								<?php $column_count++; ?>
								<th class="product-add-to-cart">
									<span class="nobr">
										<?php echo esc_html( apply_filters( 'yith_wcwl_wishlist_view_cart_heading', __( 'Actions', 'klasse-theme' ), $wishlist ) ); ?>
									</span>
								</th>
								<?php
							endif;
							?>

							<?php
							if ( $enable_drag_n_drop ) :
								?>
								<?php $column_count++; ?>
								<th class="product-arrange">
									<span class="nobr">
										<?php echo esc_html( apply_filters( 'yith_wcwl_wishlist_view_arrange_heading', __( 'Arrange', 'klasse-theme' ), $wishlist ) ); ?>
									</span>
								</th>
								<?php
							endif;
							?>
						</tr>
					</thead>

					<tbody class="wishlist-items-wrapper">
						<?php
						foreach ( $wishlist_items as $item ) :
							/**
														* Each of the wishlist items
														*
														* @var $item \YITH_WCWL_Wishlist_Item
														*/
							global $product;
							$product      = $item->get_product();
							$availability = $product->get_availability();
							$stock_status = isset( $availability['class'] ) ? $availability['class'] : false;

							if ( $product && $product->exists() ) :
								?>
									<tr id="yith-wcwl-row-<?php echo esc_attr( $item->get_product_id() ); ?>" data-row-id="<?php echo esc_attr( $item->get_product_id() ); ?>">
									<?php
									if ( $show_cb ) :
										?>
											<td class="product-checkbox">
												<input type="checkbox" value="yes" name="items[<?php echo esc_attr( $item->get_product_id() ); ?>][cb]"/>
											</td>
										<?php
									endif
									?>

										<td class="product-thumbnail">
											<div class="wishlist-item-thumbnail-wrapper">
											<?php do_action( 'yith_wcwl_table_before_product_thumbnail', $item, $wishlist ); ?>

												<a href="<?php echo esc_url( get_permalink( apply_filters( 'woocommerce_in_cart_product', $item->get_product_id() ) ) ); ?>">
												<?php echo wp_kses_post( $product->get_image() ); ?>
												</a>

											<?php do_action( 'yith_wcwl_table_after_product_thumbnail', $item, $wishlist ); ?>
											<?php
											if ( $show_remove_product ) :
												?>
													<a href="<?php echo esc_url( add_query_arg( 'remove_from_wishlist', $item->get_product_id() ) ); ?>" class="remove remove_from_wishlist" title="<?php echo esc_html( apply_filters( 'yith_wcwl_remove_product_wishlist_message_title', __( 'Remove this product', 'klasse-theme' ) ) ); ?>">&times;</a>
												<?php
											endif;
											?>
											</div>
										</td>

										<td class="product-name">
										<?php do_action( 'yith_wcwl_table_before_product_name', $item, $wishlist ); ?>

											<a href="<?php echo esc_url( get_permalink( apply_filters( 'woocommerce_in_cart_product', $item->get_product_id() ) ) ); ?>">
											<?php echo wp_kses_post( apply_filters( 'woocommerce_in_cartproduct_obj_title', $product->get_title(), $product ) ); ?>
											</a>

										<?php
										if ( $show_variation && $product->is_type( 'variation' ) ) {
											/**
																						* Product is a Variation
																						*
																						* @var $product \WC_Product_Variation
																						*/
											echo wp_kses_post( wc_get_formatted_variation( $product ) );
										}
										?>

										<?php do_action( 'yith_wcwl_table_after_product_name', $item, $wishlist ); ?>
										</td>

										<?php
										if ( $show_price || $show_price_variations ) :
											?>
											<td class="product-price">
												<?php do_action( 'yith_wcwl_table_before_product_price', $item, $wishlist ); ?>

												<?php
												if ( $show_price ) {
													echo wp_kses_post( $item->get_formatted_product_price() );
												}

												if ( $show_price_variations ) {
													echo wp_kses_post( $item->get_price_variation() );
												}
												?>

												<?php do_action( 'yith_wcwl_table_after_product_price', $item, $wishlist ); ?>
											</td>
											<?php
										endif
										?>

										<?php
										if ( $show_quantity ) :
											?>
											<td class="product-quantity">
												<?php do_action( 'yith_wcwl_table_before_product_quantity', $item, $wishlist ); ?>

												<?php
												if ( ! $no_interactions && $wishlist->current_user_can( 'update_quantity' ) ) :
													?>
													<input type="number" min="1" step="1" name="items[<?php echo esc_attr( $item->get_product_id() ); ?>][quantity]" value="<?php echo esc_attr( $item->get_quantity() ); ?>"/>
													<?php
												else :
													?>
													<?php echo esc_html( $item->get_quantity() ); ?>
													<?php
												endif;
												?>

												<?php do_action( 'yith_wcwl_table_after_product_quantity', $item, $wishlist ); ?>
											</td>
											<?php
										endif;
										?>

										<?php
										if ( $show_stock_status && get_theme_mod( 'wishlist_stock_status_toggle' ) == 1 ) :
											?>
											<td class="product-stock-status">
												<?php do_action( 'yith_wcwl_table_before_product_stock', $item, $wishlist ); ?>

												<?php echo 'out-of-stock' === $stock_status ? '<span class="wishlist-out-of-stock">' . esc_html( apply_filters( 'yith_wcwl_out_of_stock_label', __( 'Out of stock', 'klasse-theme' ) ) ) . '</span>' : '<span class="wishlist-in-stock">' . esc_html( apply_filters( 'yith_wcwl_in_stock_label', __( 'In Stock', 'klasse-theme' ) ) ) . '</span>'; ?>

												<?php do_action( 'yith_wcwl_table_after_product_stock', $item, $wishlist ); ?>
											</td>
											<?php
										endif
										?>

										<?php
										if ( $show_last_column ) :
											?>
											<td class="product-add-to-cart">
												<?php do_action( 'yith_wcwl_table_before_product_cart', $item, $wishlist ); ?>

												<!-- Date added -->
												<?php
												if ( $show_dateadded && $item->get_date_added() ) :
													// translators: date added label: 1 date added.
													echo '<span class="dateadded">' . esc_html( sprintf( __( 'Added on: %s', 'klasse-theme' ), $item->get_date_added_formatted() ) ) . '</span>';
												endif;
												?>

												<?php do_action( 'yith_wcwl_table_product_before_add_to_cart', $item, $wishlist ); ?>

												<!-- Add to cart button -->
												<?php $show_add_to_cart = apply_filters( 'yith_wcwl_table_product_show_add_to_cart', $show_add_to_cart, $item, $wishlist ); ?>
												<?php
												if ( $show_add_to_cart && isset( $stock_status ) && 'out-of-stock' !== $stock_status ) :
													?>
													<?php woocommerce_template_loop_add_to_cart( array( 'quantity' => $show_quantity ? $item->get_quantity() : 1 ) ); ?>
													<?php
												endif
												?>

												<?php do_action( 'yith_wcwl_table_product_after_add_to_cart', $item, $wishlist ); ?>

												<!-- Remove from wishlist -->
												<?php
												if ( $repeat_remove_button ) :
													?>
													<a href="<?php echo esc_url( add_query_arg( 'remove_from_wishlist', $item->get_product_id() ) ); ?>" class="remove_from_wishlist button" title="<?php echo esc_html( apply_filters( 'yith_wcwl_remove_product_wishlist_message_title', __( 'Remove this product', 'klasse-theme' ) ) ); ?>"><?php esc_html_e( 'Remove', 'klasse-theme' ); ?></a>
													<?php
												endif;
												?>

												<?php do_action( 'yith_wcwl_table_after_product_cart', $item, $wishlist ); ?>
											</td>
											<?php
										endif;
										?>
									</tr>
									<?php
							endif;
						endforeach;

						if ( ! empty( $page_links ) ) :
							?>
							<tr class="pagination-row wishlist-pagination">
								<td colspan="<?php echo esc_attr( $column_count ); ?>">
									<?php echo wp_kses_post( $page_links ); ?>
								</td>
							</tr>
							<?php
						endif
						?>
					</tbody>
					
				</table>
				<?php
			else :
				?>

			<div class="wishlist-empty-page">
				<i class="far fa-heart icon"></i>
				<p class="wishlist-empty"><?php esc_html_e( 'No products added to the wishlist', 'klasse-theme' ); ?></p>
				<p class="return-to-shop">
					<a class="button wc-backward btn-v-dark btn-go-shop theme-button theme-button-primary" href="<?php echo esc_url( apply_filters( 'woocommerce_return_to_shop_redirect', wc_get_page_permalink( 'shop' ) ) ); ?>">
						<?php esc_html_e( 'Return to the shop', 'klasse-theme' ); ?>
					</a>
				</p>
			</div>
				<?php
			endif;
			?>

			<?php
			/**
			 * Hook: yith_wcwl_wishlist_after_wishlist_content.
			 *
			 * @hooked \YITH_WCWL_Frontend::wishlist_footer - 10
			 */
			do_action( 'yith_wcwl_wishlist_after_wishlist_content', $var );
			?>

			<?php
			if ( get_theme_mod( 'wishlist_recently_viewed_products_toggle' ) == 1 ) {
				do_action( 'recently_viewed_products', $wishlist_items );
			}
			?>
		</div>
	</div>
</div>
