<?php

/**
 * YITH WooCommerce Ajax Search template
 *
 * @author YITH
 * @package YITH WooCommerce Ajax Search
 * @version 1.1.1
 */

if ( ! defined( 'YITH_WCAS' ) ) {
	exit;
} // Exit if accessed directly
wp_enqueue_script( 'yith_wcas_frontend' );
$container_class = 'yith-ajaxsearchform-container' . rand();
?>

<form class="yith-ajaxsearchform-container searchform <?php echo esc_attr( $container_class ); ?>" role="search" method="get" id="yith-ajaxsearchform" action="<?php echo esc_url( home_url( '/' ) ); ?>">
 <div class="search-wrapper">
		<?php $klsRandom = rand(); ?>
		<label class="screen-reader-text" for="yith-s-<?php echo $klsRandom; ?>"><?php esc_html_e( 'Search for:', 'klasse-theme' ); ?></label>
		<input type="search" value="<?php echo esc_attr( get_search_query() ); ?>" name="s" id="yith-s-<?php echo $klsRandom; ?>" class="yith-s" placeholder="<?php echo esc_attr( get_option( 'yith_wcas_search_input_label' ) ); ?>" data-loader-icon="<?php echo esc_attr( str_replace( '"', '', apply_filters( 'yith_wcas_ajax_search_icon', '' ) ) ); ?>" data-min-chars="<?php echo esc_attr( get_option( 'yith_wcas_min_chars' ) ); ?>" />
		<button type="submit" id="yith-searchsubmit" class="search-button" aria-label="yith-<?php _e( 'Search', 'klasse-theme' ); ?>-<?php echo $klsRandom; ?>" name="<?php _e( 'Search', 'klasse-theme' ); ?>"><i class="fas fa-search"></i></button>

	 <input type="hidden" name="post_type" value="product" />
		<?php do_action( 'wpml_add_language_form_field' ); ?>
   </div>
</form>
